/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package Chapter10.New;

import java.util.Arrays;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class GeneralArray<T> {
    T[] array;
    
    //Pass in the array you want to store when you create the object
    public GeneralArray(T[] array){
        //Store a copy of this array.
        this.array=Arrays.copyOf(array,array.length);
    }
    
    //Print the array in a user friendly manner.
    public void print(){
        System.out.println("Contents: ");
        for (T e: array){
            System.out.println(e);
        }
    }
    
    //Remove the element at position specified by index
    public void remove(int index){
        if (index < 0||index >=array.length){
            System.out.println("Index number must be between 0 and "+array.length);
            return;//Stop here to avoid index out of bounds error!
        }
        for (int i=index;i<=array.length-2;i++){
            //move all the elements up the array.
            array[i]=array[i+1];
        }
        //Shorten the array by 1
        array=Arrays.copyOf(array,array.length-1);
    }
    
    //Add the element e to the position specified by index
    public void add(int index,T e){
        if (index < 0||index >=array.length){
            System.out.println("Index number must be between 0 and "+array.length);
            return;//Stop here to avoid index out of bounds error!
        }
        //increase the array by 1
        array=Arrays.copyOf(array,array.length+1);
        //move everything from the index number onwards down the array.
        for (int i=array.length-1;i>=index+1;i--){
            array[i]=array[i-1];
        }
        //Place the new object in the array
        array[index]=e;
    }

}
